define(function (require) {
	'use strict';

	var View = require('app/base/view');
	var TimerView = require('app/views/timer');
	var ProgressBarView = require('app/views/question_progress_bar');

	var JST = window.JST;
	var _ = window._;

	return View.extend({
		template: JST['assets/tpl/tv/pre_question.html'],
		initialize: function (data) {
			data = data || {};

			this.game = data.game;
		},
		render: function () {

			var currentQuestion = this.game.getCurrentQuestion();

			this.$el.html(this.template({
				game: this.game,
				question: currentQuestion
			}));

			var timerActive = false;

			var timer = new TimerView({
				el: this.$el.find('.timer'),
				seconds: this.game.get('questionTimeLeft'),
				isActive: timerActive
			}).render();

			var progressbar = new ProgressBarView({
				el: this.$el.find('.question-progress-bar'),
				model: this.game
			}).render();

			return this;
		}
	});
});