define(function (require) {
	'use strict';

	var View = require('app/base/view');

	var JST = window.JST;
	var _ = window._;

	return View.extend({
		template: JST['assets/tpl/tv/finished.html'],
		initialize: function (data) {
			data = data || {};

			this.game = data.game;
		},
		render: function () {

			var winners = this.game.getWinners();

			this.$el.html(this.template({
				game: this.game,
				winners: winners
			}));

			return this;
		}
	});
});