define(function (require) {
	'use strict';

	var View = require('app/base/view');

	return View.extend({
		initialize: function (data) {
			this.seconds = data.seconds;
			this.isActive = typeof data.isActive != 'undefined' ? data.isActive : true;

			/**
			 * Store interval object for ticking.
			 */
			this._interval = null;
		},
		/**
		 * Stop ticking
		 */
		stop: function(){
			this.isActive = false;
		},
		render: function () {
			var that = this;

			/**
			 * Actual function that does the rendering.
			 */
			var ticker = function(){
				that.$el.html(that.seconds);

				if(!that.isActive || that.seconds <= 0){
					clearInterval(that._interval);
					that._interval = null;
				}

				that.seconds--;
			};

			if(this.isActive){
				this._interval = setInterval(ticker, 1000);
			}

			ticker();

			return this;
		}
	});

});