define(function (require) {
	'use strict';

	var View = require('app/base/view');

	return View.extend({
		template: JST['assets/tpl/common/question.stats.bar.html'],
		render: function () {
			var stats = this.model.getCurrentStats();

			var total = stats.total;

			this.$el.html(this.template({
				// Plus sign here makes it treat string back as a number.

				a: +(stats.a / total * 100).toFixed(2),
				b: +(stats.b / total * 100).toFixed(2),
				d: +(stats.d / total * 100).toFixed(2),
				c: +(stats.c / total * 100).toFixed(2),
				total: total
			}));

			return this;
		}
	});

});