define(function (require) {
	'use strict';

	var View = require('app/base/view');

	return View.extend({
		template: JST['assets/tpl/common/question.progress.bar.html'],
		render: function () {
			var isActive = this.model.get('isTimerActive');
			var stats = this.model.getCurrentStats();

			var total = stats.total;

			var correct = Math.round(stats.correct / total * 100);
			var wrong = Math.round(stats.wrong / total * 100);

			this.$el.html(this.template({
				correct: correct,
				wrong: wrong,
				isActive: isActive
			}));

			if(isActive){
				// Add active class to progress bars.
				this.$el.find('.progress-bar').addClass('progress-bar-striped').addClass('active');
			}

			return this;
		}
	});

});