define(function (require) {
	'use strict';

	var View = require('app/base/view');
	var Timer = require('app/views/timer');
	var LivesView = require('app/views/lives_left');

	return View.extend({
		events: {
			'click .btn-version-a': 'onAnswerA',
			'click .btn-version-b': 'onAnswerB',
			'click .btn-version-c': 'onAnswerC',
			'click .btn-version-d': 'onAnswerD'
		},
		template: JST['assets/tpl/client/question.html'],
		game: null,
		initialize: function (data) {
			data = data || {};

			this.game = data.game;
			this.enableTimer = this.game.isTimerActive;
		},
		render: function () {
			var user = this.game.getMeUser();

			var currentQuestion = this.game.getCurrentQuestion();

			this.$el.html(this.template({
				game: this.game,
				question: currentQuestion,
				user: user
			}));

			var questionTime = this.game.get('questionTimeLeft');

			this.questionTimer = new Timer({
				el: this.$el.find('.timer'),
				seconds: questionTime,
				isActive: this.enableTimer
			});

			this.questionTimer.render();

			var lives = new LivesView({
				el: this.$el.find('.lives-section'),
				model: this.game
			}).render();

			return this;
		},
		answer: function (variant) {
			this.$el.find('.btn-version-' + variant).addClass('active');

			// Stop timer
			this.questionTimer.stop();

			socket.emit('game-answer', {
				id: this.game.get('id'),
				questionId: this.game.getCurrentQuestion().get('id'),
				variant: variant
			});
		},
		onAnswerA: function (e) {
			e.preventDefault();
			this.answer('a');
		},
		onAnswerB: function (e) {
			e.preventDefault();
			this.answer('b');
		},
		onAnswerC: function (e) {
			e.preventDefault();
			this.answer('c');
		},
		onAnswerD: function (e) {
			e.preventDefault();
			this.answer('d');
		}
	});
});
