define(function (require) {
	'use strict';

	var View = require('app/base/view');

	var JST = window.JST;
	var _ = window._;
	var socket = window.socket;

	return View.extend({
		template: JST['assets/tpl/client/connect.html'],
		events: {
			'submit .form-connect' : 'connectToGame'
		},
		render: function (){

			this.$el.html(this.template({}));

			return this;
		},
		/**
		 * Connect to a game
		 */
		connectToGame: function(e){
			e.preventDefault();

			var username = this.$el.find('.attr-username').val();
			var gameNumber = this.$el.find('.attr-game-number').val();

			if(_(username).blank() || _(gameNumber).blank()){
				alert(polyglot.t('Please, fill in the form'));
				return;
			}

			socket.emit('game-join', {number: gameNumber, role: 'user', data : {username : username}});
		}
	});
});