define(function (require) {
	'use strict';

	var View = require('app/base/view');
	var CommonHelper = require('app/helpers/common');

	return View.extend({
		attrs: ['name', 'description', 'infoText', 'failAttempts', 'welcomeText', 'failText', 'winningText'],
		events: {
			'submit .model-form': 'submit',
			'click .btn-upload-image': 'uploadImage'
		},
		template: JST['assets/tpl/admin/quiz.edit.html'],
		render: function () {
			this.$el.html(this.template({model: this.model}));
			return this;
		},
		submit: function (e) {
			e.preventDefault();

			this.updateModel();
			var that = this;
			var wasNew = this.model.isNew();

			this.model.save()
				.done(function () {
					CommonHelper.msg(polyglot.t('Saved!'));

					if(wasNew){
						Backbone.history.navigate('/question/list/' + that.model.get('id'), {trigger: true});
					}
					else{
						Backbone.history.navigate('/quiz/list', {trigger: true});
					}
				})
				.fail(function (jqXHR) {
					CommonHelper.parseResponse(jqXHR);
				});

		},
		updateModel: function () {
			var self = this;
			var data = {};

			_.each(this.attrs, function (attr) {
				data[attr] = self.$('.attr-{attribute}'.replace('{attribute}', attr)).val()
			});

			this.model.set(data);
		},
		uploadImage: function (e) {
			e.preventDefault();
			var that = this;

			$('<input type="file" name="image" />')
				.fileupload({
					url: '/quiz/upload_image/' + that.model.get('id'),
					dataType: 'json',
					add: function (e, data) {
						that.$('.btn-upload-image').addClass('disabled');
						data.submit();
					},
					success: function () {
						location.reload();
					}
				})
				.click();
		}
	});

});