define(function (require) {
	'use strict';

	var View = require('app/base/view');
	var CommonHelper = require('app/helpers/common');

	return View.extend({
		template: JST['assets/tpl/admin/question.list.html'],
		events : {
			'change .input-order' : 'showSaveOrderButton',
			'click .btn-save-order' : 'saveNewOrder'
		},
		initialize: function (data) {
			data = data || {};

			this.quiz = data.quiz;
		},
		render: function () {
			this.$el.html(this.template({collection: this.collection, quiz: this.quiz}));
			return this;
		},
		/**
		 * User made some changes to order. Show save btn.
		 */
		showSaveOrderButton : function(){
			this.$el.find('.btn-save-order').fadeIn();
		},
		/**
		 * Save new order for questions.
		 */
		saveNewOrder : function(){
			var that = this;
			var newOrder = {};

			this.$el.find('.input-order').each(function(){
				newOrder[$(this).data('pk')] = $(this).val();
			});

			var queriesToMake = [];

			/**
			 * Resave
			 */
			this.collection.each(function(model){
				var newModelOrder = newOrder[model.get('id')];

				model.set({order: newModelOrder});

				queriesToMake.push(function(callback){
					model.save()
						.done(function(){
							callback(null);
						})
				});
			});

			async.parallel(queriesToMake, function(err){
				CommonHelper.msg(polyglot.t('Order updated.'));
				Backbone.history.navigate('/question/list/' + that.quiz.get('id'));

				window.location.reload();
			});
		}
	});

});