define(function (require) {
	'use strict';

	var View = require('app/base/view');
	var CommonHelper = require('app/helpers/common');

	return View.extend({
		attrs: ['question', 'versionA', 'versionB', 'versionC', 'versionD', 'timeLimit'],
		events: {
			'submit .model-form': 'submit',
			'click .btn-version-a': 'setCorrectA',
			'click .btn-version-b': 'setCorrectB',
			'click .btn-version-c': 'setCorrectC',
			'click .btn-version-d': 'setCorrectD',
			'click .btn-upload-image': 'uploadImage',
			'keyup .question, .versionA, .versionB, .versionC, .versionD, .timeLimit': 'updateModel'
		},
		template: JST['assets/tpl/admin/question.edit.html'],

		initialize: function (data) {
			data = data || {};

			this.quiz = data.quiz;

			this.model.on('change:correct', this.render, this);
		},
		render: function () {
			this.$el.html(this.template({model: this.model, quiz: this.quiz}));
			return this;
		},
		updateCorrect: function(){
			if(this.quiz.get('failAttempts') == 0){
				this.model.setCorrect('a');
				this.model.setCorrect('b');
				this.model.setCorrect('c');
				this.model.setCorrect('d');
			}
		},
		submit: function (e) {
			e.preventDefault();

			this.updateModel();
			var that = this;

			this.updateCorrect();

			this.model.save()
				.done(function () {
					CommonHelper.msg(polyglot.t('Saved!'));
					Backbone.history.navigate('/question/list/' + that.model.get('quizId'), {trigger: true});
				})
				.fail(function () {
					CommonHelper.parseResponse(jqXHR);
				});
		},
		updateModel: function () {
			var self = this;
			var data = {};

			_.each(this.attrs, function (attr) {
				data[attr] = self.$('.attr-{attribute}'.replace('{attribute}', attr)).val()
			});

			this.model.set(data);
		},
		uploadImage: function (e) {
			e.preventDefault();
			var self = this;

			$('<input type="file" name="image" />')
				.fileupload({
					url: '/question/upload_image/' + self.model.get('id'),
					dataType: 'json',
					add: function (e, data) {
						self.$('.btn-upload-image').addClass('disabled');
						data.submit();
					},
					success: function () {
						location.reload();
					}
				})
				.click();
		},
		setCorrectA: function () {
			this.setCorrect('a');
		},
		setCorrectB: function () {
			this.setCorrect('b');
		},
		setCorrectC: function () {
			this.setCorrect('c');
		},
		setCorrectD: function () {
			this.setCorrect('d');
		},
		setCorrect: function(variant){
			if(this.quiz.failAttemps == 0){
				return;
			}

			this.updateModel();
			this.model.toggleCorrect(variant);
		}
	});

});