define(function (require) {
	'use strict';

	var View = require('app/base/view');

	var JST = window.JST;
	var _ = window._;

	return View.extend({
		template: JST['assets/tpl/admin/game/pre_question.html'],
		events: {
			'click .btn-start-question':'startQuestion'
		},
		initialize: function (data) {
			data = data || {};

			this.game = data.game;
		},
		render: function () {

			var currentQuestion = this.game.getCurrentQuestion();

			this.$el.html(this.template({
				game: this.game,
				question: currentQuestion
			}));

			return this;
		},
		/**
		 * Start a question.
		 */
		startQuestion: function(e){
			e.preventDefault();

			socket.emit('game-start-question', {id: this.game.get('id')});

			this.undelegateEvents();
		}
	});
});