define(function (require) {
	'use strict';

	var View = require('app/base/view');

	var socket = window.socket;
	var JST = window.JST;
	var _ = window._;

	return View.extend({
		template: JST['assets/tpl/admin/game/join_users.html'],
		events: {
			'click .btn-start-quiz': 'startQuiz'
		},

		render: function () {
			this.$el.html(this.template({model: this.model}));

			return this;
		},
		startQuiz: function (e) {
			e.preventDefault();

			this.$el.find('.btn-start-quiz').hide();

			socket.emit('game-start', {id: this.model.get('id')});
		}
	});
});