define(function (require) {
	'use strict';

	var View = require('app/base/view');

	var JST = window.JST;
	var _ = window._;
	var socket = window.socket;
	var BarView = require('app/views/question_stats_bar');

	return View.extend({
		template: JST['assets/tpl/admin/game/after.question.html'],
		events : {
			'click .btn-next-question':'goToNextQuestion'
		},
		initialize: function (data) {
			data = data || {};

			this.game = data.game;
		},
		render: function () {

			var currentQuestion = this.game.getCurrentQuestion();

			var stats = this.game.getCurrentStats();

			this.$el.html(this.template({
				game: this.game,
				question: currentQuestion,
				stats: stats,
				totalAnswers : stats.a + stats.b + stats.c + stats.d
			}));

			var statsbar = new BarView({
				el: this.$el.find('.question-stats-bar'),
				model: this.game
			}).render();

			// Mark correct answers
			var correctAnswers = currentQuestion.get('correct');

			if(correctAnswers.length != 4){
				// Unless it's a quiz mode.
				var that = this;
				_.each(currentQuestion.get('correct'), function(answer){
					that.$el.find('.btn-version-'+answer).parent().addClass('correct');
				});
			}

			return this;
		},
		/**
		 * Go to next question.
		 * @param e
		 */
		goToNextQuestion: function(e){
			e.preventDefault();

			socket.emit('game-next-question', {id: this.game.get('id')});

			this.undelegateEvents();
		}
	});
});