define(function (require) {
	'use strict';

	var Model = require('app/base/model');

	return Model.extend({
		name: 'question',
		urlRoot: '/question',
		defaults: {
			question: 'New Question',
			versionA: '',
			versionB: '',
			versionC: '',
			versionD: '',
			correct: [],
			timeLimit: 15
		},
		toggleCorrect: function (version) {
			return this.isCorrect(version) ? this.setWrong(version) : this.setCorrect(version);
		},
		isCorrect: function (version) {
			return _.indexOf(this.get('correct'), version.toLowerCase()) !== -1;
		},
		isWrong: function (version) {
			return !this.isCorrect(version);
		},
		setCorrect: function (version) {
			var correct = _.clone(this.get('correct'));
			if (this.isWrong(version)) {
				correct.push(version.toLowerCase());
				this.set('correct', _.toArray(correct));
			}
			return this;
		},
		setWrong: function (version) {
			var correct = _.clone(this.get('correct'));
			if (this.isCorrect(version)) this.set('correct', _.without(correct, version.toLowerCase()));
			return this;
		}
	});

});