define(function (require) {
	'use strict';

	var Model = require('app/base/model');
	var GameUser = require('./game_user');
	var GameQuestion = require('./game_question');
	var _ = window._;
	var socket = window.socket;

	return Model.extend({
		_me: null,
		defaults: {
			questionsNumber: 10
		},
		getAdmin: function () {
			var users = this.getUsers();
			var i;

			for (i in users) {
				if (users[i].isAdmin()) return users[i];
			}

			return null;
		},
		getUsers: function () {
			var _users = [];

			_.each(this.get('users'), function (user) {
				_users.push(new GameUser(user));
			});

			return _users;
		},
		/**
		 * Get player with the largest amount of time left.
		 */
		getWinners: function(){
			var winnersToShow = 5;
			var players = this.getPlayers();

			players = _.filter(players, function(player){
				return player.get('position') > 0;
			});

			players = _.sortBy(players, function(player){
				return player.get('position');
			});

			return players.slice(0, winnersToShow);
		},
		/**
		 * Get players only.
		 * @returns {Array}
		 */
		getPlayers: function () {
			var players = [];
			var users = this.getUsers();

			_.each(users, function (user) {
				if(!user.isUser()){
					return;
				}

				players.push(user);
			});

			return players;
		},
		/**
		 * Get players that are not dead.
		 */
		getActivePlayers: function(){
			var players = [];
			var users = this.getUsers();

			_.each(users, function (user) {
				if(!user.isUser() || !user.isActive()){
					return;
				}

				players.push(user);
			});

			return players;
		},
		getQuestions: function () {
			var _questions = [];

			_.each(this.get('questions'), function (questionData) {
				_questions.push(new GameQuestion(questionData));
			});

			return _questions;
		},
		getCurrentQuestion: function () {
			return new GameQuestion(this.get('currentQuestion'));
		},
		getQuestionLeft: function () {
			return this.getQuestionsNumber() - this.get('questions').length;
		},
		/**
		 * Get statistics (wrong/right) for current question.
		 */
		getCurrentStats: function(){
			var currentQuestion = this.get('currentQuestion');
			return this.get('stats')[currentQuestion.id];
		},
		/**
		 * Get total number of questions.
		 */
		getNumberOfQuestions: function(){
			return parseInt(this.get('totalQuestions'));
		},
		/**
		 * Get a string of 1/2
		 * @returns {string}
		 */
		getQuestionRatio: function () {
			return  this.get('currentQuestionNumber') + '/' + this.getNumberOfQuestions();
		},
		getPlayerRatio: function(){
			var total = this.get('playersOnTheStart');
			var active = this.getActivePlayers().length;

			var str = total;
			if(active != total){
				str = active + '/' + str;
			}

			return str;
		},
		getQuestionsNumber: function () {
			return parseInt(this.get('questionsNumber'));
		},
		isFirstQuestion: function () {
			return this.getQuestionsNumber();
		},
		isLastQuestion: function () {
			return this.getQuestionLeft() === this.getQuestionsNumber();
		},
		getMeUser: function () {
			return this.getUserById(this.getMe().get('id'));
		},
		getUserById: function(id){
			var users = this.getUsers();
			var i;

			for (i in users) {
				if (users[i].get('id') === id) return users[i];
			}

			return null;
		},
		getMe: function () {
			return this._me;
		},
		setMe: function (me) {
			this._me = me;
			return this;
		}
	});

});