define(function (require) {
	'use strict';

	var CommonHelper = require('app/helpers/common');

	var GameModel = require('app/models/game');

	var WaitingScreen = require('app/views/tv/waiting_screen');
	var JoinUsersView = require('app/views/tv/join_users');

	var GamePreQuestionView = require('app/views/tv/pre_question');
	var GameQuestionView = require('app/views/tv/question');
	var GameAfterQuestionView = require('app/views/tv/after_question');
	var GameFinishedView = require('app/views/tv/finished');

	var socket = window.socket;

	return function (quiz) {

		$('body').addClass('screen-tv');

		var game = null;

		var currentScreen = new WaitingScreen({model: game});
		currentScreen.render().html();

		socket
			.on('game-created', function (data) {
				if(data.game.quiz.id == quiz.id && game == null){
					game = new GameModel();
					game.set(data.game);

					// If the game is created, automatically join it.
					socket.emit('game-join', {id: game.get('id'), role: 'tv', data: {username: 'tv'}});
					currentScreen = new JoinUsersView({model: game});
					currentScreen.render().html();
				}
			})
			.on('game-users-updated', function (data) {
				game.set(data.game);
				if(!game.get('started')){
					currentScreen = new JoinUsersView({model: game});
					currentScreen.render().html();
				}
			})
			.on('game-pre-question', function (data) {
				game.set(data.game);

				currentScreen = new GamePreQuestionView({game: game});
				currentScreen.render().html();
			})
			.on('game-question', function (data) {
				game.set(data.game);
				currentScreen = new GameQuestionView({game: game});
				currentScreen.render().html();
			})
			.on('answer-accepted', function(data){
				game.set(data.game);

				currentScreen = new GameQuestionView({game: game});
				currentScreen.render().html();
			})

			.on('game-after-question', function (data) {
				game.set(data.game);

				currentScreen = new GameAfterQuestionView({game: game});
				currentScreen.render().html();
			})
			.on('game-message', function (data) {
				CommonHelper.msg(data.message, {type: data.type || 'info'});
			})
			.on('game-showing-winners', function (data) {
				currentScreen = new GameFinishedView({game: game.set(data)});
				currentScreen.render().html();
			})
			/*.on('game-finished', function () {
				// And show interface
				currentScreen = new WaitingScreen({model: game});
				currentScreen.render().html();
			})
			.on('game-destoyed', function(){
				// game destroyed.
				var currentScreen = new WaitingScreen({model: game});
				currentScreen.render().html();
			})
			 */
			.on('error', function (data) {
				CommonHelper.errorMsg(data.message);
			});
	}

});