define(function (require) {
	'use strict';

	var QuizCollection = require('app/collections/quiz');

	var LoadingView = require('app/views/loading');
	var CommonHelper = require('app/helpers/common');

	var QuizListView = require('app/views/admin/quiz_list');

	return function () {
		var quizes = new QuizCollection();

		var loadingView = new LoadingView().render().html();

		$.when(quizes.fetch())
			.done(function () {
				new QuizListView({collection: quizes}).render().html();
			})
			.fail(function () {
				CommonHelper.errorMsg('Fetch failed.');
			})
			.always(function () {
				loadingView.remove();
			});

	};

});