define(function (require) {
	'use strict';

	var QuizModel = require('app/models/quiz');
	var QuizEditView = require('app/views/admin/quiz_edit');

	var LoadingView = require('app/views/loading');
	var CommonHelper = require('app/helpers/common');

	return function (id) {
		var quiz = new QuizModel({id: id});

		var loadingView = new LoadingView().render().html();

		$.when(quiz.fetch())
			.done(function () {
				new QuizEditView({model: quiz}).render().html();
			})
			.fail(function () {
				CommonHelper.errorMsg(polyglot.t('Fetching error.'));
			})
			.always(function () {
				loadingView.remove();
			});
	}
});