define(function (require) {
	'use strict';

	var QuestionCollection = require('app/collections/question');
	var QuizModel = require('app/models/quiz');

	var LoadingView = require('app/views/loading');
	var CommonHelper = require('app/helpers/common');

	var QuestionListView = require('app/views/admin/question_list');

	return function (quizId) {
		var quiz = new QuizModel({id: quizId});

		var questions = new QuestionCollection();
		var loadingView = new LoadingView().render().html();

		$.when(questions.fetch({data: {quizId: quizId, sort: 'order'}}, quiz.fetch()))
			.done(function () {
				new QuestionListView({collection: questions, quiz: quiz}).render().html();
			})
			.fail(function () {
				CommonHelper.errorMsg(polyglot.t('Fetch failed.'));
			})
			.always(function () {
				loadingView.remove();
			});

	};

});