define(function (require) {
	'use strict';

	var QuestionModel = require('app/models/question');
	var QuizModel = require('app/models/quiz');
	var QuestionEditView = require('app/views/admin/question_edit');

	var LoadingView = require('app/views/loading');
	var CommonHelper = require('app/helpers/common');

	return function (id) {
		var question = new QuestionModel({id: id});

		var loadingView = new LoadingView().render().html();

		$.when(question.fetch())
			.done(function () {
				var quiz = new QuizModel({id: question.get('quizId')});

				$.when(quiz.fetch())
					.done(function () {
						new QuestionEditView({model: question, quiz: quiz}).render().html();
					});
			})
			.fail(function () {
				CommonHelper.errorMsg(polyglot.t('Fetching error.'));
			})
			.always(function () {
				loadingView.remove();
			});
	}
});