define(function (require) {
	'use strict';

	var QuestionModel = require('app/models/question');

	var LoadingView = require('app/views/loading');
	var CommonHelper = require('app/helpers/common');

	return function (id) {
		var question = new QuestionModel({id: id});
		var loadingView = new LoadingView().render().html();

		question.fetch()
			.done(function () {
				// First get a question to get some data from it.
				var quizId = question.get('quizId');

				question.destroy()
					.done(function () {
						CommonHelper.msg(polyglot.t('Question deleted.'));
						Backbone.history.navigate('/question/list/' + quizId, {trigger: true});
					})
					.fail(function () {
						CommonHelper.errorMsg(polyglot.t('Cannot delete a question.'));
					})
					.always(function () {
						loadingView.remove();
					});
			});

	}
});