define(function (require) {
	'use strict';

	var QuizModel = require('app/models/quiz');
	var QuestionModel = require('app/models/question');

	var LoadingView = require('app/views/loading');
	var CommonHelper = require('app/helpers/common');

	return function (quizId) {
		var quiz = new QuizModel({id: quizId});

		var loadingView = new LoadingView().render().html();

		$.when(quiz.fetch())
			.done(function () {
				var question = new QuestionModel();
				question.set({quizId : quizId});

				// Silently add a new question
				// And redirect to edit.
				question.save()
					.done(function () {
						Backbone.history.navigate('/question/edit/' + question.get('id'), {trigger: true});
					})
					.fail(function () {
						CommonHelper.errorMsg(polyglot.t('Error adding question.'));
					});
			})
			.fail(function () {
				CommonHelper.errorMsg(polyglot.t('Fetching error.'));
			})
			.always(function () {
				loadingView.remove();
			});
	}
});