define(function (require) {
	'use strict';

	var CommonHelper = require('app/helpers/common');

	var GameModel = require('app/models/game');

	var JoinUsersView = require('app/views/admin/game/join_users');
	var GameQuestionView = require('app/views/admin/game/question');
	var GamePreQuestionView = require('app/views/admin/game/pre_question');
	var GameAfterQuestionView = require('app/views/admin/game/after_question');
	var GameFinishedView = require('app/views/admin/game/finished');

	var socket = window.socket;

	return function (quiz) {

		$('body').addClass('screen-admin');

		var game = null;

		// Auto create a new game on load.
		socket.emit('game-create', {quizId: quiz.id});

		socket
			.on('game-created', function (data) {
				if(game == null){
					game = new GameModel();

					game.set(data.game);
					new JoinUsersView({model: game}).render().html();
				}
			})
			.on('game-users-updated', function (data) {
				game.set(data.game);
				if(!game.get('started')){
					new JoinUsersView({model: game}).render().html();
				}
			})
			.on('game-pre-question', function (data) {
				game.set(data.game);
				new GamePreQuestionView({game: game}).render().html();
			})
			.on('game-question', function (data) {
				game.set(data.game);
				new GameQuestionView({game: game}).render().html();
			})
			.on('answer-accepted', function(data){
				game.set(data.game);
				new GameQuestionView({game: game}).render().html();
			})

			.on('game-after-question', function (data) {
				game.set(data.game);
				new GameAfterQuestionView({game: game.set(data.game)}).render().html();
			})
			.on('game-message', function (data) {
				CommonHelper.msg(data.message, {type: data.type || 'info'});
			})
			.on('game-showing-winners', function (data) {
				new GameFinishedView({game: game.set(data)}).render().html();
			})
			/*
			.on('game-finished', function () {
				window.location.href = '/admin/';
			})
			*/
			.on('game-destoyed', function(){
				// game destroyed.
				window.location.reload();
			})
			.on('error', function (data) {
				CommonHelper.errorMsg(data.message);
			});
	}

});