require(
	[
		'polyglot_boot',

		'app/actions/admin/quiz.list',
		'app/actions/admin/quiz.add',
		'app/actions/admin/quiz.edit',

		'app/actions/admin/question.list',
		'app/actions/admin/question.add',
		'app/actions/admin/question.edit',
		'app/actions/admin/question.del',

		'app/actions/not_found'
	],
	function (
		Polyglot,

		quizList,
		quizAdd,
		quizEdit,

		questionList,
		questionAdd,
		questionEdit,
		questionDel,

		notFound
	) {
		'use strict';

		new (Backbone.Router.extend({
			routes: {
				'': quizList,
				'quiz': quizList,
				'quiz/list': quizList,
				'quiz/add': quizAdd,
				'quiz/edit/:id': quizEdit,

				'question/list/:quizId': questionList,
				'question/add/:quizId': questionAdd,
				'question/edit/:id': questionEdit,
				'question/delete/:id': questionDel,

				'*default': notFound
			},
			initialize: function () {

				Backbone.history.start();
			}
		}));

	}
);