<?php
/**
 * Date: 07.03.16 15:59
 * Making my life easier.
 */
namespace app;

ini_set('display_errors', 1);
date_default_timezone_set('UTC');
error_reporting(E_ERROR | E_PARSE | E_WARNING);
require_once "classes/Generator.php";


if(isset($_POST['Generator'])){
	try {
		$generator = new Generator();
		$generator->save($_POST['Generator']);

		$url = $_POST['Generator']['url'];

		echo "Newsletter saved! <br><a href=\"{$url}\">{$url}</a>";
		exit;
	}
	catch(\Exception $e){
		echo $e->getMessage();
		exit();
	}
}

?>

<!doctype html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<title>Newsletter Generator 3000</title>

	<link rel="stylesheet" href="main.css">
</head>
<body>
	<h1>Newsletter Generator 3000</h1>

	<form method="post" enctype="multipart/form-data">
		<div class="form-group">
			<h3>1. Select the image</h3>

			<input type="file" name="image">

			<p>
				Image should be jpg. Recommended width is 700px. <br>
				You can however use higher image width, though in some mail clients user will have to scroll.
			</p>
		</div>

		<h3>2. Set up page texts:</h3>

		<div class="form-group">
			<label><img src="img/help-title.jpg" alt=""><br> Page title</label>

			
			<input type="text" name="Generator[title]">
		</div>

		<div class="form-group">
			<label>Alternative image text (shown when image cannot be loaded)</label>
			<textarea name="Generator[alt]" cols="30" rows="10"></textarea>
		</div>

		<h3>3. Set up Urls:</h3>

		<div class="form-group">
			<label>Link for the image (leave empty for no link):</label>
			<input type="text" name="Generator[link]">
		</div>

		<div class="form-group">
			<label>Path on the server:</label>
			<input type="text" name="Generator[url]" value="http://html.congresso.no/">
		</div>

		<div class="form-group">
			<button>Process</button>
		</div>
	</form>
</body>
</html>

