<?php
namespace app;

/**
 * Date: 07.03.16 16:23
 * Handles image data.
 */
class UploadedImage{

	/**
	 * Name of the input.
	 */
	const INPUT_VAR = 'image';

	/**
	 * Width of the image
	 * @var integer
	 */
	public $width;

	/**
	 * Height of the image.
	 * @var integer
	 */
	public $height;

	/**
	 * Path for the image on the server.
	 * @var string
	 */
	public $savedPath;

	/**
	 * Does simple validation. Throws expections on error.
	 */
	public function validate()
	{
		$image = $_FILES[self::INPUT_VAR];

		if(empty($image) || empty($image['name']) || $image['error'] != 0 || $image['size'] == 0 || $image['type'] != 'image/jpeg'){
			throw new \InvalidArgumentException('Image was not uploaded correctly. #1');
		}

		$fileType = pathinfo($image['name'], PATHINFO_EXTENSION);

		if(!in_array(strtolower($fileType), ['jpg', 'jpeg'])){
			throw new \InvalidArgumentException('Image was not uploaded correctly. #2');
		}

		$imageSize = getimagesize($image['tmp_name']);

		if($imageSize === false){
			throw new \InvalidArgumentException('Image was not uploaded correctly. #3');
		}
		else{
			$this->width = $imageSize[0];
			$this->height = $imageSize[1];
		}
	}

	/**
	 * Saves the image in the specified path.
	 *
	 * @param string $path Path to save image to
	 */
	public function save($path)
	{
		if (!move_uploaded_file($_FILES[self::INPUT_VAR]['tmp_name'], $path)) {
			throw new \InvalidArgumentException('Image was not uploaded correctly. #4');
		}

		$this->savedPath = $path;
	}
}