<?php
namespace app;

/**
 * Date: 07.03.16 16:23
 * Handles newsletter html code.
 */
class Newsletter{

	/**
	 * Hardcoded image name.
	 */
	const IMAGE_FILENAME = 'vg.jpg';

	/**
	 * Filename of the html newsletter file.
	 */
	const HTML_FILENAME = 'index.html';


	/**
	 * Page title
	 * @var string
	 */
	public $title = '';

	/**
	 * Alt text for img tag
	 * @var string
	 */
	public $alt = '';

	/**
	 * Whether img is clickable.
	 * @var bool
	 */
	public $hasLink = false;

	/**
	 * What is the link around img tag.
	 * @var string
	 */
	public $link = '';

	/**
	 * Image class
	 * @var UploadedImage
	 */
	public $image;

	/**
	 * Url of the newsletter on server.
	 * @var string
	 */
	public $url;

	/**
	 * Creates newsletter and stored incoming data.
	 * @param string $title
	 * @param string $alt
	 * @param string $link
	 * @param string $url
	 * @param UploadedImage $image
	 */
	public function __construct($title, $alt, $link, $url, $image)
	{
		$this->title = $title;
		$this->alt = $alt;
		$this->link = $link;

		$this->hasLink = trim($link) !== '';

		$this->image = $image;
		$this->url = $url;
	}

	/**
	 * Template to copy.
	 */
	public function getTemplatePath(){
		return __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'templates' . DIRECTORY_SEPARATOR . 'template.php';
	}

	/**
	 * Saves the newsletter.
	 * Will trigger image processing.
	 *
	 * @param string $path Server path to save to
	 *
	 * @return string
	 */
	public function save($path)
	{
		$this->image->save($path . DIRECTORY_SEPARATOR . self::IMAGE_FILENAME);

		$this->processTemplate($path . DIRECTORY_SEPARATOR . self::HTML_FILENAME);

		return $this->url;
	}

	/**
	 * Reads template, replaces keywords in it and saves in the path.4
	 */
	private function processTemplate($path)
	{
		ob_start();
		ob_implicit_flush(false);
		require($this->getTemplatePath());

		$template = ob_get_clean();

		file_put_contents($path, $template);
	}
}