<?php
namespace app;

require_once "UploadedImage.php";
require_once "Newsletter.php";

/**
 * Date: 07.03.16 16:23
 * Handles general logic.
 */
class Generator{

	/**
	 * Part of the path that is server specific.
	 */
	const DOMAIN_PART = 'http://html.congresso.no/';

	/**
	 * Base path on the server
	 */
//	const BASE_PATH = '/Users/undsoft/htdocs/html/generator/saves/';
	const BASE_PATH = '/var/www/';

	/**
	 * All the fields we expect from user.
	 * @var array
	 */
	private $_inputFields = [
		'title' => "Title",
		'alt' => "Alternative Text",
		'url' => "Path on The Server"
	];

	/**
	 * Processes the newsletter. Validates user input (will throw error)
	 * @param array $data
	 * @return string Url of newsletter
	 */
	public function save($data)
	{
		$data = $this->cleanInput($data);
		$this->ensureFolder($data['path']);

		$image = new UploadedImage();
		$image->validate();
		$newsletter = new Newsletter($data['title'], $data['alt'], $data['link'], $data['url'], $image);

		return $newsletter->save($data['path']);
	}


	/**
	 * Sets class config based on the user input.
	 * @param array $data
	 * @return array $cleanInput Sanitized input
	 */
	private function cleanInput($data){

		$cleanInput = [];
		foreach ($this->_inputFields as $key => $name) {
			if (empty($data[$key])) {
				throw new \InvalidArgumentException("{$name} field is missing.");
			}

			$cleanInput[$key] = $data[$key];
		}

		if(isset($data['link'])){
			$cleanInput['link'] = $data['link'];
		}

		// Cut the path portion.
		if(strpos($cleanInput['url'], self::DOMAIN_PART) !== 0){
			throw new \InvalidArgumentException('Incorrect path on server was specified.');
		}

		$cleanPath = substr($cleanInput['url'], strlen(self::DOMAIN_PART));

		if(empty($cleanPath)){
			throw new \InvalidArgumentException('No server path specified');
		}

		$cleanInput['path'] = self::BASE_PATH . $cleanPath;


		return $cleanInput;
	}

	/**
	 * Make sure we can create the folder.
	 * @param string $path
	 * @throws \ErrorException
	 */
	private function ensureFolder($path)
	{
		if(file_exists($path) && is_dir($path)){
			// Directory exists. Proceed only if empty.
			$existingFiles = scandir($path);

			if($existingFiles > 2){
				throw new \ErrorException('The path on server that you have chosen already exists.');
			}
		}
		else{
			mkdir($path, 0755, true);
		}
	}
}
